/*
 * Decompiled with CFR 0.152.
 */
package LukesBits;

import java.awt.Color;
import java.io.Serializable;

public class Colour
implements Serializable {
    public static Colour red = new Colour(255, 0, 0);
    public static Colour green = new Colour(0, 255, 0);
    public static Colour blue = new Colour(0, 0, 255);
    public final int r;
    public final int g;
    public final int b;

    public Color toColor() {
        return new Color(this.r, this.g, this.b);
    }

    public Colour(int _r, int _g, int _b) {
        int n = _r < 0 ? 0 : (this.r = _r > 255 ? 255 : _r);
        int n2 = _g < 0 ? 0 : (this.g = _g > 255 ? 255 : _g);
        this.b = _b < 0 ? 0 : (_b > 255 ? 255 : _b);
    }

    public Colour dim(double dim) {
        return new Colour(this.tidy((int)Math.round((double)this.r * dim)), this.tidy((int)Math.round((double)this.g * dim)), this.tidy((int)Math.round((double)this.b * dim)));
    }

    public Colour times(Colour colour) {
        double timesr = (double)colour.r / 255.0;
        double timesg = (double)colour.g / 255.0;
        double timesb = (double)colour.b / 255.0;
        return new Colour(this.tidy((int)Math.round((double)this.r * timesr)), this.tidy((int)Math.round((double)this.g * timesg)), this.tidy((int)Math.round((double)this.b * timesb)));
    }

    public Colour add(Colour colour) {
        return new Colour(this.tidy(this.r + colour.r), this.tidy(this.g + colour.g), this.tidy(this.b + colour.b));
    }

    private int tidy(int me) {
        if (me < 0) {
            me = 0;
        }
        if (me > 255) {
            me = 255;
        }
        return me;
    }

    public Colour clone() {
        return new Colour(this.r, this.g, this.b);
    }

    public String toString() {
        return "(" + this.r + "," + this.g + "," + this.b + ")";
    }

    public static Colour hsvToRgb(double h, double s, double v) {
        double b;
        double g;
        double r;
        int i = (int)Math.floor(h * 6.0);
        double f = h * 6.0 - (double)i;
        double p = v * (1.0 - s);
        double q = v * (1.0 - f * s);
        double t = v * (1.0 - (1.0 - f) * s);
        switch (i % 6) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new Colour((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0));
    }
}

