/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import LukesBits.Vector;
import fractal.FractalSettings;
import fractal.Mandelbrot;

public class BurningShip
extends Mandelbrot {
    public BurningShip(double _cycleMultiplier, boolean _smoothColour) {
        super(_cycleMultiplier, _smoothColour);
        this.defaultCycleMultiplier = 15.0;
        this.defaultCycleOffset = 0.65;
        this.resetColour();
    }

    @Override
    protected Complex newZ(Complex z, Complex c) {
        Complex q = new Complex(Math.abs(z.re()), Math.abs(z.im()));
        return q.times(q).plus(c.times(-1.0));
    }

    @Override
    public String toString() {
        return "f(z) = (|Re(z)| + i|Im(z)|)^2 + c, CycleMultiplier: " + this.cycleMultiplier;
    }

    @Override
    public double defaultZoom() {
        return 3.5;
    }

    @Override
    public int defaultDetail() {
        return 50;
    }

    @Override
    public Vector defaultCentre() {
        return new Vector(0.4, 0.3);
    }

    @Override
    public FractalSettings defaultSettings() {
        return new FractalSettings(this.defaultZoom(), this.defaultDetail(), this.defaultCentre(), this);
    }
}

