/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import fractal.Mandelbrot;
import java.awt.Color;

public class CollatzFractal
extends Mandelbrot {
    public CollatzFractal() {
        super(false);
        this.cycleMultiplier = this.defaultCycleMultiplier = 1.0;
    }

    public int iterations(Complex z, Complex c, int detail) {
        int i;
        for (i = 0; c.magnitudeSqrd() < (double)detail && i < detail; ++i) {
            c = c.times(7.0).plus(new Complex(2.0, 0.0)).minus(c.times(5.0).plus(new Complex(2.0, 0.0)).times(c.times(Math.PI).cos())).times(0.25);
        }
        return i;
    }

    @Override
    public Color getColourFor(Complex z, Complex c, int detail) {
        int i = this.iterations(z, c, detail);
        if (i == detail) {
            return new Color(0, 0, 0);
        }
        double s = i;
        double cycleSize = Math.log(detail) * this.cycleMultiplier;
        double colour = (s + this.cycleOffset * cycleSize) % cycleSize / cycleSize;
        return Color.getHSBColor((float)colour, 0.8f, 1.0f);
    }
}

