/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.Fractal;
import fractal.FunctionOfZ;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ColourDialogue
extends JDialog {
    private FunctionOfZ fz;
    private Fractal fractal;
    private JTextField cycleMultiplierField;
    private JTextField cycleOffsetField;
    public final JDialog thisPanel = this;

    public ColourDialogue(FunctionOfZ _fz, Fractal _fractal, Window window) {
        super(window);
        this.fz = _fz;
        this.fractal = _fractal;
        this.setTitle("Colour Settings");
        GridLayout g = new GridLayout(3, 3, 10, 10);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(g);
        this.add(new JLabel("Cycle Multiplier:"));
        this.cycleMultiplierField = new JTextField(this.fz.getCycleMultiplier() + "");
        this.add(this.cycleMultiplierField);
        this.add(new JLabel("Default:" + this.fz.getDefaultCycleMultiplier()));
        this.add(new JLabel("Cycle Offset:"));
        this.cycleOffsetField = new JTextField(this.fz.getCycleOffset() + "");
        this.add(this.cycleOffsetField);
        this.add(new JLabel("Default:" + this.fz.getDefaultCycleOffset() + " Range:0-1"));
        JButton cancel = new JButton("Cancel");
        this.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourDialogue.this.setVisible(false);
            }
        });
        JButton reset = new JButton("Reset");
        this.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourDialogue.this.reset();
            }
        });
        JButton ok = new JButton("Use");
        this.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourDialogue.this.use();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
        this.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    public void open() {
        this.reset();
        this.setVisible(true);
    }

    private void use() {
        try {
            this.fz.setCycleMultiplier(Double.parseDouble(this.cycleMultiplierField.getText()));
            this.fz.setCycleOffset(Double.parseDouble(this.cycleOffsetField.getText()));
            this.setVisible(false);
            this.fractal.generate();
        }
        catch (NumberFormatException er) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid inputs", "Error", 0);
        }
    }

    private void reset() {
        this.cycleMultiplierField.setText(this.fz.getCycleMultiplier() + "");
        this.cycleOffsetField.setText(this.fz.getCycleOffset() + "");
    }
}

