/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.Fractal;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;

public class CustomExport
extends JDialog {
    private Fractal fractal;
    private Window parent;
    private JLabel aaLabel;
    private JComboBox aaSelect;
    private JButton cancel;
    private JButton export;
    private JTextField height;
    private JLabel heightLabel;
    private JCheckBox infoBox;
    private JLabel infoLabel;
    private JTextField width;
    private JLabel widthLabel;

    public CustomExport(Fractal _fractal, Window _parent) {
        super(_parent);
        this.parent = _parent;
        this.fractal = _fractal;
        this.initComponents();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(_parent);
        this.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    private void initComponents() {
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.width = new JTextField();
        this.height = new JTextField();
        this.aaLabel = new JLabel();
        this.aaSelect = new JComboBox();
        this.cancel = new JButton();
        this.export = new JButton();
        this.infoBox = new JCheckBox();
        this.infoLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Image");
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.widthLabel.setText("Width");
        this.heightLabel.setText("Height");
        this.width.setText("1920");
        this.height.setText("1080");
        this.height.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomExport.this.heightActionPerformed(evt);
            }
        });
        this.aaLabel.setText("AA");
        this.aaSelect.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "2x", "4x", "8x"}));
        this.aaSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomExport.this.aaSelectActionPerformed(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomExport.this.cancelActionPerformed(evt);
            }
        });
        this.export.setText("Export");
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomExport.this.exportActionPerformed(evt);
            }
        });
        this.infoBox.setSelected(true);
        this.infoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomExport.this.infoBoxActionPerformed(evt);
            }
        });
        this.infoLabel.setText("Info");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthLabel).addComponent(this.heightLabel).addComponent(this.aaLabel).addComponent(this.infoLabel)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.height, GroupLayout.Alignment.LEADING, -1, 115, Short.MAX_VALUE).addComponent(this.width).addComponent(this.aaSelect, 0, -1, Short.MAX_VALUE)).addComponent(this.infoBox))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.export))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.width, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.heightLabel).addComponent(this.height, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aaLabel).addComponent(this.aaSelect, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.infoBox, -1, -1, Short.MAX_VALUE).addComponent(this.infoLabel, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.export).addComponent(this.cancel)).addContainerGap()));
        this.pack();
    }

    private void heightActionPerformed(ActionEvent evt) {
    }

    private void aaSelectActionPerformed(ActionEvent evt) {
    }

    private void infoBoxActionPerformed(ActionEvent evt) {
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void exportActionPerformed(ActionEvent evt) {
        String filename = this.fractal.getFileName();
        int aa = (int)Math.pow(2.0, this.aaSelect.getSelectedIndex());
        int w = Integer.parseInt(this.width.getText());
        int h = Integer.parseInt(this.height.getText());
        filename = filename + "_" + w + "x" + h + (aa > 1 ? "_" + aa + "aa" : "");
        if (this.infoBox.isSelected()) {
            try {
                this.fractal.saveInfo(filename);
            }
            catch (IOException ex) {
                Logger.getLogger(CustomExport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ProgressMonitor progressMonitor = new ProgressMonitor(this.parent, "Exporting to " + filename + ".png", null, 0, w + (aa > 1 ? 2 : 1));
        progressMonitor.setMillisToDecideToPopup(0);
        this.fractal.saveCertainRez(filename, w, h, aa, progressMonitor);
        this.setVisible(false);
    }
}

