/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import LukesBits.Image;
import LukesBits.Vector;
import fractal.BurningShip;
import fractal.CollatzFractal;
import fractal.CustomFunction2;
import fractal.FractalSettings;
import fractal.FractalThread;
import fractal.FractalWindow;
import fractal.FunctionOfZ;
import fractal.IFractalWindow;
import fractal.Julia;
import fractal.Mandelbrot;
import jargs.gnu.CmdLineParser;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ProgressMonitor;

public class Fractal {
    private IFractalWindow window;
    private int width;
    private int height;
    private int detail;
    private int drawDetail;
    private int threads;
    private BufferedImage bufferImage;
    private int threadsDrawnTo;
    private int finishedThreads;
    private Vector centre;
    private Vector drawCentre;
    private double zoom;
    private double drawZoom;
    private double adjustedZoom;
    private double adjustedDrawZoom;
    private double zoomAdjust = 0.8;
    private int upscale;
    private boolean allowSave;
    private boolean generationInProgress;
    private boolean needReGenerate;
    private boolean cancelGeneration;
    private boolean saveWhenFinished;
    private boolean aa;
    private String saveAs;
    private FractalThread[] fractalThreads;
    private Thread[] threadClasses;
    private FunctionOfZ functionOfZ;
    private ProgressMonitor progressMonitor;
    private int chunkWidth = 10;

    public static void printUsage() {
        System.out.println("Usage: -w --width Image width (pixels)\n-h --height Image height (pixels)\n-t --threads Number of threads\n");
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option widthArg = parser.addIntegerOption('w', "width");
        CmdLineParser.Option heightArg = parser.addIntegerOption('h', "height");
        CmdLineParser.Option threadsArg = parser.addIntegerOption('t', "threads");
        CmdLineParser.Option upScaleArg = parser.addIntegerOption('u', "upscale");
        CmdLineParser.Option animationArg = parser.addBooleanOption('a', "animation");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            Fractal.printUsage();
        }
        int width = (Integer)parser.getOptionValue(widthArg, 600);
        int height = (Integer)parser.getOptionValue(heightArg, 600);
        int threads = (Integer)parser.getOptionValue(threadsArg, Runtime.getRuntime().availableProcessors());
        int upscale = (Integer)parser.getOptionValue(upScaleArg, 4);
        boolean animation = (Boolean)parser.getOptionValue(animationArg, false);
        if (animation) {
            int i;
            int upTo = 1000;
            int skip = 500;
            String folderName = (int)(System.currentTimeMillis() / 1000L) + "";
            new File("images/" + folderName).mkdir();
            Vector c = new Vector(-0.5699636380381331, -0.5617647004128065, 0.0);
            double z = 3.0;
            for (i = 0; i < skip; ++i) {
                z *= 0.95;
            }
            for (i = skip; i < upTo; ++i) {
                Mandelbrot fz = new Mandelbrot(30.0, true);
                Fractal f = new Fractal(width * upscale, height * upscale, true, threads);
                f.loadSettings(c, z, 1000);
                f.saveWhenFinished("/" + folderName + "/" + i);
                f.generate();
                f.setAA(false);
                z *= 0.95;
                try {
                    while (!f.ready()) {
                        Thread.sleep(100L);
                    }
                    continue;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Fractal.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            Complex mu = new Complex(0.36237, 0.32);
            Julia fz = new Julia(mu, Julia.ColourType.COSINE);
            Fractal f = new Fractal(width, height, true, threads);
            f.setUpscale(upscale);
            FractalWindow w = new FractalWindow(f, width, height);
            f.setWindow(w);
        }
    }

    public Fractal(int _width, int _height, int _threads, FunctionOfZ _functionOfZ, int _detail, double _zoom, Vector _centre, String _saveAs, boolean _aa) {
        this(_width, _height, _threads, _functionOfZ, _detail, _zoom, _centre, _saveAs, _aa, null);
    }

    public Fractal(int _width, int _height, int _threads, FunctionOfZ _functionOfZ, int _detail, double _zoom, Vector _centre, String _saveAs, boolean _aa, ProgressMonitor _progMon) {
        this.width = _width;
        this.height = _height;
        this.threads = _threads;
        this.functionOfZ = _functionOfZ;
        this.detail = _detail;
        this.zoom = _zoom;
        this.centre = _centre;
        this.saveWhenFinished = true;
        this.saveAs = _saveAs;
        this.aa = _aa;
        this.progressMonitor = _progMon;
        this.init();
        this.generate();
    }

    public Fractal(int _width, int _height, int _threads, FunctionOfZ _functionOfZ, int _detail, double _zoom, Vector _centre) {
        this.width = _width;
        this.height = _height;
        this.threads = _threads;
        this.functionOfZ = _functionOfZ;
        this.detail = _detail;
        this.zoom = _zoom;
        this.centre = _centre;
        this.saveWhenFinished = false;
        this.aa = false;
        this.init();
    }

    public Fractal(int _width, int _height, boolean _allowSave, int _threads) {
        this.width = _width;
        this.height = _height;
        this.allowSave = _allowSave;
        this.threads = _threads;
        this.init();
        this.loadMandelbrot();
    }

    public Fractal(int _width, int _height, int _threads) {
        this.width = _width;
        this.height = _height;
        this.allowSave = false;
        this.threads = _threads;
        this.functionOfZ = new Mandelbrot(10.0, false);
        this.functionOfZ.setCycleMultiplier(0.0);
        this.reset(false);
        this.detail = 100;
        this.init();
    }

    private void init() {
        this.bufferImage = new BufferedImage(this.width, this.height, 1);
        this.generationInProgress = false;
        this.needReGenerate = false;
        this.fractalThreads = new FractalThread[this.threads];
        this.threadClasses = new Thread[this.threads];
        this.upscale = 4;
        this.cancelGeneration = false;
    }

    public void setChunkWidth(int c) {
        this.chunkWidth = c;
    }

    public void loadMandelbrot() {
        this.functionOfZ = new Mandelbrot(30.0, true);
        this.reset();
    }

    public void loadCustomFunction() {
        this.functionOfZ = new CustomFunction2();
        this.reset();
    }

    public void loadMandelbrot(double k) {
        this.functionOfZ = new Mandelbrot(k);
        this.reset();
    }

    public void setDetail(int _detail) {
        this.detail = _detail;
    }

    public void setCentre(Complex c) {
        this.setCentre(new Vector(c.re(), c.im()));
    }

    public void setCentre(Vector v) {
        this.centre = v = new Vector(v.x, v.y);
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean redraw) {
        this.centre = this.functionOfZ.defaultCentre();
        this.zoom = this.functionOfZ.defaultZoom();
        this.detail = this.functionOfZ.defaultDetail();
        if (redraw) {
            this.generate();
        }
    }

    public void resetColour() {
        this.functionOfZ.resetColour();
        this.generate();
    }

    public int getThreads() {
        return this.threads;
    }

    public int getDetail() {
        return this.detail;
    }

    public FunctionOfZ getFunctionOfZ() {
        return this.functionOfZ;
    }

    public FractalSettings exportSettings() {
        return new FractalSettings(this.zoom, this.detail, this.centre, this.functionOfZ);
    }

    public void loadSettings(FractalSettings settings) {
        this.zoom = settings.zoom;
        this.centre = settings.centre;
        this.detail = settings.detail;
        this.functionOfZ = settings.fz;
        this.generate();
    }

    public void cancelGenerate() {
        this.cancelGeneration = true;
        this.needReGenerate = false;
    }

    public void loadBurningShip() {
        this.functionOfZ = new BurningShip(30.0, true);
        this.reset();
    }

    public void loadCollatz() {
        this.functionOfZ = new CollatzFractal();
        this.reset();
    }

    public void loadJuliaQuadratic() {
        this.functionOfZ = new Julia(new Complex(-0.7268953477091141, 0.18888712904384594), Julia.ColourType.COSINE);
        this.reset();
    }

    public void loadCustomJuliaQuadratic(Complex mu) {
        this.functionOfZ = new Julia(mu, Julia.ColourType.COSINE);
        this.reset();
    }

    public void key(int key) {
        switch (key) {
            case 40: 
            case 225: {
                this.move(0, 1);
                break;
            }
            case 37: 
            case 226: {
                this.move(-1, 0);
                break;
            }
            case 39: 
            case 227: {
                this.move(1, 0);
                break;
            }
            case 38: 
            case 224: {
                this.move(0, -1);
                break;
            }
            case 107: {
                this.changeDetail(true);
                break;
            }
            case 109: {
                this.changeDetail(false);
                break;
            }
            case 154: {
                if (!this.allowSave) break;
                this.save();
            }
        }
        this.window.repaint();
    }

    public void setWindow(IFractalWindow _window) {
        this.window = _window;
        this.generate();
    }

    public void saveWhenFinished(String _saveAs) {
        this.saveWhenFinished = true;
        this.saveAs = _saveAs;
    }

    public void loadSettings(Vector _centre, double _zoom, int _detail) {
        this.centre = _centre;
        this.zoom = _zoom;
        this.detail = _detail;
        this.generate();
    }

    public void setAA(boolean _aa) {
        this.aa = _aa;
    }

    public void setUpscale(int _upscale) {
        this.upscale = _upscale;
    }

    public boolean ready() {
        return !this.generationInProgress;
    }

    public void setProgressMonitor(ProgressMonitor pm) {
        this.progressMonitor = pm;
    }

    public void move(int x, int y) {
        this.centre = this.centre.add(new Vector(x, y), this.zoom * 0.1);
        this.generate();
    }

    public void changeDetail(boolean more) {
        double m = 5.0;
        this.detail = more ? (int)((double)this.detail * m) : (int)((double)this.detail / m);
        this.generate();
    }

    public void drag(Point down, Point up) {
        if (down != null) {
            Complex downC = this.pixelToComplex(down.x, down.y);
            Complex upC = this.pixelToComplex(up.x, up.y);
            Complex difference = upC.minus(downC);
            this.centre = this.centre.subtract(difference.toVector());
            this.window.repaint();
            this.generate();
        }
    }

    public void scroll(int scroll) {
        this.scroll(scroll, this.window.getMousePosition(true));
    }

    public void scrollNoMouse(int scroll) {
        this.scroll(scroll, new Point(this.width / 2, this.height / 2));
    }

    public void scroll(int scroll, Point m) {
        if (m != null) {
            Vector mouseComplex = this.pixelToComplex(m.x, m.y).toVector();
            double oldZoom = this.zoom;
            double oldAdjustedZoom = this.adjustedZoom;
            Vector oldCentre = this.centre;
            this.updateZoom(scroll);
            this.centre = mouseComplex.subtract(new Vector(m.x - this.width / 2, this.height / 2 - m.y).multiply(this.adjustedZoom));
            double ratio = this.zoom / oldZoom;
            if (ratio < 1.0) {
                double sampleWidth = (double)this.width * ratio;
                double sampleHeight = (double)this.height * ratio;
                Vector newCentrePixels = this.complexToPixel(this.centre, oldAdjustedZoom, oldCentre);
                BufferedImage zoomImage = this.bufferImage.getSubimage((int)Math.round(newCentrePixels.x - sampleWidth / 2.0), (int)Math.round(newCentrePixels.y - sampleHeight / 2.0), (int)Math.round(sampleWidth), (int)Math.round(sampleHeight));
                this.bufferImage = Image.getScaledInstance(zoomImage, this.width, this.height, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
            } else {
                double newHeight = (double)this.height / ratio;
                double newWidth = (double)this.width / ratio;
                Vector oldCentrePixels = this.complexToPixel(oldCentre, this.adjustedZoom, this.centre);
                BufferedImage zoomImage = Image.getScaledInstance(this.bufferImage, (int)Math.round(newWidth), (int)Math.round(newHeight), RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
                Graphics g = this.bufferImage.getGraphics();
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, this.width, this.height);
                g.drawImage(zoomImage, (int)Math.round(oldCentrePixels.x - newWidth / 2.0), (int)Math.round(oldCentrePixels.y - newHeight / 2.0), null);
            }
        } else {
            this.updateZoom(scroll);
        }
        this.generate();
        this.window.repaint();
    }

    public double getZoom() {
        return this.zoom;
    }

    private void updateZoom(int scroll) {
        this.zoom = scroll < 0 ? (this.zoom *= this.zoomAdjust) : (this.zoom /= this.zoomAdjust);
        this.adjustedZoom = this.zoom / (double)Math.min(this.width, this.height);
    }

    public Vector complexToPixel(Vector c, double _adjustedZoom, Vector centre) {
        Vector intermediate = c.subtract(centre);
        intermediate = intermediate.multiply(1.0 / _adjustedZoom);
        return new Vector((double)this.width * 0.5 + intermediate.x, (double)this.height * 0.5 - intermediate.y);
    }

    public Complex pixelToComplex(int x, int y) {
        return this.pixelToComplex(x, y, this.adjustedZoom, this.centre);
    }

    private Complex pixelToComplex(int x, int y, double _adjustedZoom) {
        return this.pixelToComplex(x, y, _adjustedZoom, this.centre);
    }

    private Complex pixelToComplex(int x, int y, double _adjustedZoom, Vector centre) {
        Vector diff = new Vector(x - this.width / 2, this.height / 2 - y);
        diff = diff.multiply(_adjustedZoom);
        Vector c = centre.add(diff);
        return new Complex(c.x, c.y);
    }

    public void generateStrip(int x1, int x2) {
        for (int x = x1; x < x2; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Complex c = this.pixelToComplex(x, y, this.adjustedDrawZoom);
                Complex z = new Complex(0.0, 0.0);
                Color colour = this.functionOfZ.getColourFor(z, c, this.drawDetail);
                this.bufferImage.setRGB(x, y, colour.getRGB());
            }
        }
    }

    public synchronized void generate() {
        if (!this.generationInProgress) {
            this.generationInProgress = true;
            this.needReGenerate = false;
            this.drawDetail = this.detail;
            this.drawCentre = this.centre.copy();
            this.drawZoom = this.zoom;
            this.finishedThreads = 0;
            this.adjustedZoom = this.adjustedDrawZoom = this.drawZoom / (double)Math.min(this.width, this.height);
            if (this.progressMonitor != null) {
                this.progressMonitor.setMaximum(this.width + (this.aa ? 2 : 1));
                this.progressMonitor.setNote("Generating Image");
            }
            if (this.threads > 1) {
                this.threadsDrawnTo = 0;
                for (int t = 0; t < this.threads; ++t) {
                    int drawTo = this.threadsDrawnTo + this.chunkWidth;
                    if (drawTo > this.width) {
                        drawTo = this.width;
                    }
                    this.fractalThreads[t] = new FractalThread(this, this.threadsDrawnTo, drawTo, t);
                    this.threadClasses[t] = new Thread(this.fractalThreads[t]);
                    this.threadClasses[t].start();
                    this.threadsDrawnTo += this.chunkWidth;
                }
            } else {
                for (int x = 0; x < this.width; ++x) {
                    this.generateStrip(x, x + 1);
                }
                this.cancelGeneration = false;
                this.generationInProgress = false;
                if (this.window != null) {
                    this.window.repaint();
                }
                if (this.saveWhenFinished) {
                    this.save(this.saveAs, this.aa, false);
                }
            }
        } else {
            this.needReGenerate = true;
            this.cancelGeneration = true;
        }
    }

    public synchronized void threadFinished(int id, FractalThread t) {
        if (t.stopped()) {
            return;
        }
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.cancelGeneration = true;
        }
        if (this.cancelGeneration) {
            for (int i = 0; i < this.threads; ++i) {
                this.fractalThreads[i].stop();
            }
            this.cancelGeneration = false;
            this.generationInProgress = false;
            if (this.needReGenerate) {
                this.generate();
            }
        } else if (this.threadsDrawnTo < this.width) {
            int drawTo = this.threadsDrawnTo + this.chunkWidth;
            if (drawTo > this.width) {
                drawTo = this.width;
            }
            this.fractalThreads[id].newXs(this.threadsDrawnTo, drawTo);
            this.threadClasses[id] = new Thread(this.fractalThreads[id]);
            this.threadClasses[id].start();
            this.threadsDrawnTo += this.chunkWidth;
        } else {
            ++this.finishedThreads;
        }
        if (this.window != null) {
            this.window.repaint();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.setProgress(this.threadsDrawnTo);
        }
        if (this.finishedThreads >= this.threads) {
            this.generationInProgress = false;
            if (this.saveWhenFinished) {
                this.save(this.saveAs, this.aa, false);
            }
            if (this.needReGenerate) {
                this.generate();
            }
        }
    }

    public String getFileName() {
        new File("images/").mkdir();
        return "images/" + (int)(System.currentTimeMillis() / 1000L);
    }

    public void save() {
        String filename = this.getFileName();
        this.save(filename, false, true);
    }

    public void saveBig(String filename) {
        this.saveBig(filename, this.upscale, true, null);
    }

    public void saveBig(String filename, int scale, boolean _aa, ProgressMonitor pm) {
        this.saveBig(filename, scale, scale, _aa, pm);
    }

    public void saveBig(String filename, int scaleUp, int scaleDown, boolean _aa, ProgressMonitor pm) {
        Fractal f = new Fractal(this.width * scaleUp, this.height * scaleUp, this.threads, this.functionOfZ, this.detail, this.zoom, this.centre, filename, _aa, pm);
        f.setUpscale(scaleDown);
        f.setChunkWidth(1);
    }

    public void saveCertainRez(String filename, int w, int h, int aaLevel, ProgressMonitor pm) {
        Fractal f = new Fractal(w * aaLevel, h * aaLevel, this.threads, this.functionOfZ, this.detail, this.zoom, this.centre, filename, aaLevel > 1, pm);
        f.setUpscale(aaLevel);
        f.setChunkWidth(1);
    }

    public void saveInfo(String filename) throws IOException {
        FileWriter fstream = new FileWriter(filename + ".txt");
        BufferedWriter out = new BufferedWriter(fstream);
        out.write(this.infoString(true));
        out.close();
    }

    public void save(String filename, boolean aa, boolean info) {
        this.save(filename, aa, info, false);
    }

    public void save(String filename, boolean aa, boolean info, boolean applet) {
        try {
            if (aa) {
                if (this.progressMonitor != null) {
                    this.progressMonitor.setNote("Resizing Image");
                }
                BufferedImage aaImage = Image.getScaledInstance(this.bufferImage, this.width / this.upscale, this.height / this.upscale, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
                if (this.progressMonitor != null) {
                    this.progressMonitor.setNote("Saving Image");
                    this.progressMonitor.setProgress(this.width + 1);
                }
                if (!applet) {
                    ImageIO.write((RenderedImage)aaImage, "png", new File(filename + ".png"));
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(this.width + 2);
                }
            } else {
                if (this.progressMonitor != null) {
                    this.progressMonitor.setNote("Saving Image");
                }
                ImageIO.write((RenderedImage)this.bufferImage, "png", new File(filename + ".png"));
                if (this.progressMonitor != null) {
                    this.progressMonitor.setProgress(this.width + 1);
                }
            }
            if (info) {
                this.saveInfo(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Fractal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String statusText() {
        return this.infoString(false);
    }

    private String infoString(boolean detailed) {
        return "Centre: " + (detailed ? "(" + this.centre.x + "," + this.centre.y + ")" : this.centre.toString(true)) + ", " + "Zoom: " + (detailed ? this.zoom : (double)Math.round(this.zoom * 10000.0) / 10000.0) + ", " + "Detail: " + this.detail + ", " + this.functionOfZ.toString(detailed);
    }

    public synchronized void draw(Graphics g) {
        g.drawImage(this.bufferImage, 0, 0, null);
    }
}

