/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.ColourDialogue;
import fractal.Fractal;
import fractal.FractalPanel;
import fractal.GoToDialogue;
import fractal.IFractalWindow;
import fractal.JuliaSelectDialogue;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class FractalApplet
extends JApplet
implements IFractalWindow,
KeyListener {
    Fractal fractal;
    private Point mouseDown;
    private FractalPanel panel;
    private JLabel statusLabel;
    private int width;
    private int height;
    private final JRootPane thisPanel = this.getRootPane();

    @Override
    public void init() {
        Dimension d = this.getSize();
        this.fractal = new Fractal(d.width, d.height, false, Runtime.getRuntime().availableProcessors());
        this.fractal.setWindow(this);
        this.width = d.width;
        this.height = d.height;
        this.panel = new FractalPanel(this.fractal, d.width - 10, d.height - 10);
        this.add(this.panel);
        this.setupMenus();
        this.addStatusPanel();
        this.setFocusable(true);
        this.addKeyListener(this);
    }

    private void addStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new BevelBorder(1));
        this.add((Component)statusPanel, "South");
        statusPanel.setPreferredSize(new Dimension(this.getWidth(), 20));
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.statusLabel = new JLabel("status");
        this.statusLabel.setHorizontalAlignment(2);
        statusPanel.add(this.statusLabel);
    }

    private void setupMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fractalMenu = new JMenu("Fractal");
        JMenu colourMenu = new JMenu("Colours");
        JMenu controlMenu = new JMenu("Controls");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem loadMandelbrot = new JMenuItem("Mandelbrot");
        fractalMenu.add(loadMandelbrot);
        loadMandelbrot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.loadMandelbrot();
            }
        });
        JMenuItem loadMandelbrot4 = new JMenuItem("'Mandelbrot' with x^n");
        fractalMenu.add(loadMandelbrot4);
        loadMandelbrot4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nString = JOptionPane.showInputDialog(FractalApplet.this.rootPane, "f(x) = x^n + c, where n = (can be non-int)", "4");
                if (nString != null) {
                    FractalApplet.this.fractal.loadMandelbrot(Double.parseDouble(nString));
                }
            }
        });
        JMenuItem loadShip = new JMenuItem("Burning Ship");
        fractalMenu.add(loadShip);
        loadShip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.loadBurningShip();
            }
        });
        JMenuItem loadJulia = new JMenuItem("Julia Quadratic");
        fractalMenu.add(loadJulia);
        loadJulia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.loadJuliaQuadratic();
            }
        });
        JMenuItem loadCustomJulia = new JMenuItem("Custom Julia Quadratic");
        fractalMenu.add(loadCustomJulia);
        loadCustomJulia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JuliaSelectDialogue d = new JuliaSelectDialogue(FractalApplet.this.fractal, SwingUtilities.windowForComponent(FractalApplet.this.thisPanel));
                d.setVisible(true);
            }
        });
        JMenuItem resetColour = new JMenuItem("Reset");
        colourMenu.add(resetColour);
        resetColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.resetColour();
            }
        });
        JMenuItem changeColour = new JMenuItem("Custom");
        colourMenu.add(changeColour);
        changeColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourDialogue d = new ColourDialogue(FractalApplet.this.fractal.getFunctionOfZ(), FractalApplet.this.fractal, SwingUtilities.windowForComponent(FractalApplet.this.thisPanel));
                d.open();
            }
        });
        JMenuItem reset = new JMenuItem("Reset View");
        controlMenu.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.reset();
            }
        });
        JMenuItem goTo = new JMenuItem("Go To");
        controlMenu.add(goTo);
        goTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToDialogue d = new GoToDialogue(FractalApplet.this.fractal, SwingUtilities.windowForComponent(FractalApplet.this.thisPanel));
                d.setVisible(true);
            }
        });
        JMenuItem zoomIn = new JMenuItem("Zoom In");
        controlMenu.add(zoomIn);
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.scrollNoMouse(-1);
            }
        });
        JMenuItem zoomOut = new JMenuItem("Zoom Out");
        controlMenu.add(zoomOut);
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.scrollNoMouse(1);
            }
        });
        JMenuItem moreDetail = new JMenuItem("Increase Detail");
        controlMenu.add(moreDetail);
        moreDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.changeDetail(true);
            }
        });
        JMenuItem lessDetail = new JMenuItem("Decrease Detail");
        controlMenu.add(lessDetail);
        lessDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalApplet.this.fractal.changeDetail(false);
            }
        });
        JMenuItem help = new JMenuItem("Help");
        helpMenu.add(help);
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(FractalApplet.this.thisPanel, "Use the arrow keys or click and drag the cursor to move the viewport.\nThe mouse scroll wheel or Control Menu will zoom in and out.\n+/- keys or the Control menu can change the detail level.\n Higher detail levels take longer to render.\nClick on a point to centre the view around it", "Help - JavaFractal", 1);
            }
        });
        JMenuItem website = new JMenuItem("Website");
        helpMenu.add(website);
        website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(new URI("http://www.lukewallin.co.uk/graphics/fractals"));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (URISyntaxException use) {
                        use.printStackTrace();
                    }
                }
            }
        });
        JMenuItem about = new JMenuItem("About");
        helpMenu.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(FractalApplet.this.thisPanel, "JavaFractal is Copyright (c) Luke Wallin 2012\nReleased under LGPL\nwww.lukewallin.co.uk/graphics/fractals\nluke.wallin@gmail.com", "JavaFractal revision 27", 1);
            }
        });
        menuBar.add(fractalMenu);
        menuBar.add(colourMenu);
        menuBar.add(controlMenu);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.fractal.key(e.getKeyCode());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.fractal.ready()) {
            this.statusLabel.setText(this.fractal.statusText());
        } else {
            this.statusLabel.setText("Generating...");
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        this.fractal.key(key);
        e.consume();
    }

    @Override
    public void saving(int x) {
    }
}

