/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.Fractal;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

public class FractalPanel
extends JPanel {
    private Fractal fractal;
    private Point mouseDown;

    public void setFractal(Fractal f) {
        this.fractal = f;
    }

    public FractalPanel(Fractal _fractal, int width, int height) {
        this.fractal = _fractal;
        this.setSize(new Dimension(width, height));
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                FractalPanel.this.mouseWheel(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                FractalPanel.this._mouseReleased(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                FractalPanel.this._mousePressed(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                FractalPanel.this._mouseClicked(evt);
            }
        });
        this.setVisible(true);
    }

    private void _mousePressed(MouseEvent evt) {
        this.mouseDown = evt.getPoint();
    }

    private void _mouseClicked(MouseEvent evt) {
        Point p = evt.getPoint();
        this.fractal.setCentre(this.fractal.pixelToComplex(p.x, p.y));
    }

    private void _mouseReleased(MouseEvent evt) {
        Point mouseUp = evt.getPoint();
        this.fractal.drag(this.mouseDown, mouseUp);
        this.mouseDown = null;
    }

    private void mouseWheel(MouseWheelEvent evt) {
        int scroll = evt.getWheelRotation();
        this.fractal.scroll(scroll);
        evt.consume();
    }

    @Override
    public void paint(Graphics g) {
        this.fractal.draw(g);
    }
}

