/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.ColourDialogue;
import fractal.CustomExport;
import fractal.Fractal;
import fractal.FractalPanel;
import fractal.FractalSettings;
import fractal.GoToDialogue;
import fractal.IFractalWindow;
import fractal.JuliaSelectDialogue;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;

public class FractalWindow
extends JFrame
implements IFractalWindow {
    private Fractal fractal;
    private FractalPanel panel;
    private JPanel progressPanel;
    private ProgressMonitor progressMonitor;
    private JLabel statusLabel;
    private int width;
    private int height;
    private int xPadding;
    private int yPadding;
    private ProgressMonitor progMon;
    private JMenu exportMenu;
    private JMenuBar menuBar;
    private final FractalWindow thisPanel = this;

    public FractalWindow(Fractal _fractal, int _width, int _height) {
        this.panel = new FractalPanel(_fractal, _width, _height);
        this.fractal = _fractal;
        this.width = _width;
        this.height = _height;
        this.setDefaultCloseOperation(3);
        this.setupMenus();
        this.add(this.panel);
        this.addStatusPanel();
        this.getContentPane().setPreferredSize(new Dimension(this.width, this.height));
        this.pack();
        this.setVisible(true);
        Dimension d = this.getSize();
        this.xPadding = d.width - this.width;
        this.yPadding = d.height - this.height;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FractalWindow.this.key(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FractalWindow.this.beenResized(e);
            }
        });
    }

    private void beenResized(ComponentEvent e) {
        Dimension d = this.getSize();
        int w = d.width - this.xPadding;
        int h = d.height - this.yPadding;
        if (w != this.width || h != this.height) {
            this.resizeFractal(w, h);
        }
    }

    public void resizeWindow(int w, int h) {
        this.resizeFractal(w, h);
        this.getContentPane().setPreferredSize(new Dimension(this.width, this.height));
        this.pack();
    }

    public void resizeFractal(int w, int h) {
        this.width = w;
        this.height = h;
        FractalSettings s = this.fractal.exportSettings();
        this.fractal.cancelGenerate();
        this.fractal = new Fractal(w, h, true, this.fractal.getThreads());
        this.fractal.setWindow(this);
        this.fractal.loadSettings(s);
        this.panel.setFractal(this.fractal);
        this.menuBar.remove(this.exportMenu);
        this.setupExportMenu();
        this.menuBar.add((Component)this.exportMenu, 4);
    }

    @Override
    public Point getMousePosition(boolean children) {
        return this.panel.getMousePosition();
    }

    private void addStatusPanel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(new BevelBorder(1));
        this.add((Component)statusPanel, "South");
        statusPanel.setPreferredSize(new Dimension(this.getWidth(), 20));
        statusPanel.setLayout(new BoxLayout(statusPanel, 0));
        this.statusLabel = new JLabel("status");
        this.statusLabel.setHorizontalAlignment(2);
        statusPanel.add(this.statusLabel);
    }

    private void setupMenus() {
        this.menuBar = new JMenuBar();
        JMenu fractalMenu = new JMenu("Fractal");
        JMenu colourMenu = new JMenu("Colours");
        JMenu controlMenu = new JMenu("Controls");
        JMenu windowMenu = new JMenu("Window");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem loadMandelbrot = new JMenuItem("Mandelbrot");
        fractalMenu.add(loadMandelbrot);
        loadMandelbrot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.loadMandelbrot();
            }
        });
        JMenuItem loadMandelbrot4 = new JMenuItem("'Mandelbrot' with x^n");
        fractalMenu.add(loadMandelbrot4);
        loadMandelbrot4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String nString = JOptionPane.showInputDialog(FractalWindow.this.rootPane, "f(x) = x^n + c, where n = (can be non-int)", "4");
                    if (nString != null) {
                        FractalWindow.this.fractal.loadMandelbrot(Double.parseDouble(nString));
                    }
                }
                catch (NumberFormatException er) {
                    JOptionPane.showMessageDialog(FractalWindow.this.rootPane, "Invalid inputs", "Error", 0);
                }
            }
        });
        JMenuItem loadShip = new JMenuItem("Burning Ship");
        fractalMenu.add(loadShip);
        loadShip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.loadBurningShip();
            }
        });
        JMenuItem loadJulia = new JMenuItem("Julia Quadratic");
        fractalMenu.add(loadJulia);
        loadJulia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.loadJuliaQuadratic();
            }
        });
        JMenuItem loadCustomJulia = new JMenuItem("Custom Julia Quadratic");
        fractalMenu.add(loadCustomJulia);
        loadCustomJulia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JuliaSelectDialogue d = new JuliaSelectDialogue(FractalWindow.this.fractal, FractalWindow.this.thisPanel);
                d.setVisible(true);
            }
        });
        JMenuItem resetColour = new JMenuItem("Reset");
        colourMenu.add(resetColour);
        resetColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.resetColour();
            }
        });
        JMenuItem changeColour = new JMenuItem("Custom");
        colourMenu.add(changeColour);
        changeColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourDialogue d = new ColourDialogue(FractalWindow.this.fractal.getFunctionOfZ(), FractalWindow.this.fractal, FractalWindow.this.thisPanel);
                d.open();
            }
        });
        JMenuItem reset = new JMenuItem("Reset View");
        controlMenu.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.reset();
            }
        });
        JMenuItem goTo = new JMenuItem("Go To");
        controlMenu.add(goTo);
        goTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToDialogue d = new GoToDialogue(FractalWindow.this.fractal, FractalWindow.this.thisPanel);
                d.setVisible(true);
            }
        });
        JMenuItem zoomIn = new JMenuItem("Zoom In");
        controlMenu.add(zoomIn);
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.scrollNoMouse(-1);
            }
        });
        JMenuItem zoomOut = new JMenuItem("Zoom Out");
        controlMenu.add(zoomOut);
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.scrollNoMouse(1);
            }
        });
        JMenuItem moreDetail = new JMenuItem("Increase Detail");
        controlMenu.add(moreDetail);
        moreDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.changeDetail(true);
            }
        });
        JMenuItem lessDetail = new JMenuItem("Decrease Detail");
        controlMenu.add(lessDetail);
        lessDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.changeDetail(false);
            }
        });
        JMenuItem resize600 = new JMenuItem("600x600 (1:1)");
        windowMenu.add(resize600);
        resize600.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.thisPanel.resizeWindow(600, 600);
            }
        });
        JMenuItem resize1024 = new JMenuItem("1024x768 (4:3)");
        windowMenu.add(resize1024);
        resize1024.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.thisPanel.resizeWindow(1024, 768);
            }
        });
        JMenuItem resize1280_9 = new JMenuItem("1280x720 (16:9)");
        windowMenu.add(resize1280_9);
        resize1280_9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.thisPanel.resizeWindow(1280, 720);
            }
        });
        JMenuItem resize1280 = new JMenuItem("1280x800 (16:10)");
        windowMenu.add(resize1280);
        resize1280.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.thisPanel.resizeWindow(1280, 800);
            }
        });
        JMenuItem help = new JMenuItem("Help");
        helpMenu.add(help);
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(FractalWindow.this.thisPanel, "Use the arrow keys or click and drag the cursor to move the viewport.\nThe mouse scroll wheel or Control Menu will zoom in and out.\n+/- keys or the Control menu can change the detail level.\n Higher detail levels take longer to render.\nClick on a point to centre the view around it", "Help - JavaFractal", 1);
            }
        });
        JMenuItem website = new JMenuItem("Website");
        helpMenu.add(website);
        website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(new URI("http://www.lukewallin.co.uk/graphics/fractals"));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    catch (URISyntaxException use) {
                        use.printStackTrace();
                    }
                }
            }
        });
        JMenuItem about = new JMenuItem("About");
        helpMenu.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(FractalWindow.this.thisPanel, "JavaFractal is Copyright (c) Luke Wallin 2012\nReleased under LGPL\nwww.lukewallin.co.uk/graphics/fractals\nluke.wallin@gmail.com", "JavaFractal revision 27", 1);
            }
        });
        this.setupExportMenu();
        this.menuBar.add(fractalMenu);
        this.menuBar.add(colourMenu);
        this.menuBar.add(controlMenu);
        this.menuBar.add(windowMenu);
        this.menuBar.add(this.exportMenu);
        this.menuBar.add(helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    private void setupExportMenu() {
        this.exportMenu = new JMenu("Export");
        JMenuItem standardExport = new JMenuItem("Info + Preview");
        this.exportMenu.add(standardExport);
        standardExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FractalWindow.this.fractal.save();
            }
        });
        JMenuItem customExport = new JMenuItem("Custom");
        this.exportMenu.add(customExport);
        customExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomExport d = new CustomExport(FractalWindow.this.fractal, FractalWindow.this.thisPanel);
                d.setVisible(true);
            }
        });
        JMenuItem aa4Export = new JMenuItem("4xAA - " + this.width + "x" + this.height);
        this.exportMenu.add(aa4Export);
        aa4Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FractalWindow.this.fractal.getFileName() + FractalWindow.this.width + "x" + FractalWindow.this.height + "_4aa";
                FractalWindow.this.progressMonitor = new ProgressMonitor(FractalWindow.this.thisPanel, "Exporting to " + filename + ".png", null, 0, FractalWindow.this.width + 1);
                FractalWindow.this.progressMonitor.setMillisToDecideToPopup(0);
                FractalWindow.this.fractal.saveBig(filename, 4, true, FractalWindow.this.progressMonitor);
            }
        });
        JMenuItem myRezaa4Export = new JMenuItem("4xAA - 1680x1050");
        this.exportMenu.add(myRezaa4Export);
        myRezaa4Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FractalWindow.this.fractal.getFileName() + "_1680x1050_4aa";
                FractalWindow.this.progressMonitor = new ProgressMonitor(FractalWindow.this.thisPanel, "Exporting to " + filename + ".png", null, 0, FractalWindow.this.width + 1);
                FractalWindow.this.progressMonitor.setMillisToDecideToPopup(0);
                FractalWindow.this.fractal.saveCertainRez(filename, 1680, 1050, 4, FractalWindow.this.progressMonitor);
            }
        });
        JMenuItem hdaa4Export = new JMenuItem("4xAA - 1920x1080 (HD)");
        this.exportMenu.add(hdaa4Export);
        hdaa4Export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = FractalWindow.this.fractal.getFileName() + "_hd_4aa";
                FractalWindow.this.progressMonitor = new ProgressMonitor(FractalWindow.this.thisPanel, "Exporting to " + filename + ".png", null, 0, FractalWindow.this.width + 1);
                FractalWindow.this.progressMonitor.setMillisToDecideToPopup(0);
                FractalWindow.this.fractal.saveCertainRez(filename, 1920, 1080, 4, FractalWindow.this.progressMonitor);
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.fractal.ready()) {
            this.statusLabel.setText(this.fractal.statusText());
        } else {
            this.statusLabel.setText("Generating...");
        }
    }

    private void key(KeyEvent evt) {
        int key = evt.getKeyCode();
        this.fractal.key(key);
    }

    @Override
    public void saving(int progress) {
    }
}

