/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Vector;
import fractal.Fractal;
import fractal.FractalSettings;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GoToDialogue
extends JDialog {
    private Window parent;
    private Fractal fractal;
    private JTextField x;
    private JTextField y;
    private JTextField zoom;

    public GoToDialogue(Fractal _fractal, Window _parent) {
        super(_parent);
        this.fractal = _fractal;
        this.parent = _parent;
        this.setTitle("Viewport Settings");
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridLayout(5, 2, 10, 5));
        JLabel centreText = new JLabel("Centre = ");
        this.add(centreText);
        JLabel centreText2 = new JLabel("x + iy");
        this.add(centreText2);
        JLabel xText = new JLabel("x = ");
        this.add(xText);
        this.x = new JTextField(this.fractal.getFunctionOfZ().defaultCentre().x + "");
        this.add(this.x);
        JLabel yTeyt = new JLabel("y = ");
        this.add(yTeyt);
        this.y = new JTextField(this.fractal.getFunctionOfZ().defaultCentre().y + "");
        this.add(this.y);
        JLabel zoomText = new JLabel("Zoom = ");
        this.add(zoomText);
        this.zoom = new JTextField(this.fractal.getZoom() + "");
        this.add(this.zoom);
        JButton cancel = new JButton("Cancel");
        this.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToDialogue.this.setVisible(false);
            }
        });
        JButton ok = new JButton("Use");
        this.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoToDialogue.this.use();
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.parent);
        this.setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    public void use() {
        try {
            FractalSettings s = this.fractal.exportSettings();
            s.zoom = Double.parseDouble(this.zoom.getText());
            s.centre = new Vector(Double.parseDouble(this.x.getText()), Double.parseDouble(this.y.getText()));
            this.fractal.loadSettings(s);
            this.setVisible(false);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid inputs", "Error", 0);
        }
    }
}

