/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Colour;
import LukesBits.Complex;
import LukesBits.Vector;
import fractal.FractalSettings;
import fractal.FunctionOfZ;
import java.awt.Color;

public class Julia
implements FunctionOfZ {
    protected Complex mu;
    private ColourType colour;
    protected double cycleMultiplier;
    protected double cycleOffset;
    protected boolean smoothColour;
    public double defaultCycleMultiplier = 50.0;
    public double defaultCycleOffset = 0.5;

    @Override
    public Vector defaultCentre() {
        return new Vector(0.0, 0.0);
    }

    @Override
    public int defaultDetail() {
        return 1000;
    }

    @Override
    public double defaultZoom() {
        return 3.0;
    }

    @Override
    public double getCycleMultiplier() {
        return this.cycleMultiplier;
    }

    @Override
    public double getCycleOffset() {
        return this.cycleOffset;
    }

    @Override
    public double getDefaultCycleOffset() {
        return this.defaultCycleOffset;
    }

    @Override
    public double getDefaultCycleMultiplier() {
        return this.defaultCycleMultiplier;
    }

    @Override
    public void setCycleMultiplier(double _cycleMultiplier) {
        this.cycleMultiplier = _cycleMultiplier;
    }

    @Override
    public void setCycleOffset(double _cycleOffset) {
        this.cycleOffset = _cycleOffset;
    }

    @Override
    public FractalSettings defaultSettings() {
        return new FractalSettings(this.defaultZoom(), this.defaultDetail(), this.defaultCentre(), this);
    }

    @Override
    public void resetColour() {
        this.cycleMultiplier = this.defaultCycleMultiplier;
        this.cycleOffset = this.defaultCycleOffset;
    }

    public Julia(Complex _mu, ColourType _colour) {
        this.mu = _mu;
        this.colour = _colour;
        this.cycleMultiplier = this.defaultCycleMultiplier;
        this.cycleOffset = this.defaultCycleOffset;
    }

    public Complex newC(Complex c) {
        return c.times(c).plus(this.mu);
    }

    @Override
    public Color getColourFor(Complex z, Complex c, int detail) {
        int i;
        Complex oldC = c;
        for (i = 0; c.magnitudeSqrd() < 4.0 && i < detail; ++i) {
            oldC = c;
            c = this.newC(c);
        }
        switch (this.colour) {
            case COSINE: {
                Complex p = c.minus(oldC);
                double angle = Math.atan2(p.im(), p.re());
                if (angle < 0.0) {
                    angle += Math.PI;
                }
                if (c.magnitudeSqrd() >= 4.0) {
                    c = c.times(c).plus(this.mu);
                    ++i;
                    c = c.times(c).plus(this.mu);
                    double s = (double)(++i) - Math.log(Math.log(c.abs())) / Math.log(2.0);
                    double cycleSize = Math.log(detail) * this.cycleMultiplier;
                    double co = (s + cycleSize * this.cycleOffset) % cycleSize / cycleSize;
                    return Color.getHSBColor((float)co, 0.5f, 1.0f);
                }
                return Colour.blue.dim(1.0 - angle / Math.PI).toColor();
            }
        }
        if (c.magnitudeSqrd() >= 4.0) {
            return new Colour(255, 255, 255).toColor();
        }
        return new Colour(0, 0, 0).toColor();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean detailed) {
        return "f(z) = z^2 + " + this.mu + (detailed ? ", CycleMultiplier:" + this.cycleMultiplier + ", CycleOffset: " + this.cycleOffset : "");
    }

    public static enum ColourType {
        COSINE,
        NONE;

    }
}

