/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import fractal.Fractal;
import fractal.JuliaSelectPanel;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JuliaSelectDialogue
extends JDialog {
    private Fractal fractal;
    private JPanel JuliaPanel;
    private JButton cancelButton;
    private JButton drawButton;
    private JTextField im;
    private JLabel imLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel muLabel;
    private JTextField re;
    private JButton resetButton;
    private JLabel title;

    public JuliaSelectDialogue(Fractal _fractal, Window parent) {
        super(parent);
        this.fractal = _fractal;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public int getThreads() {
        return this.fractal.getThreads();
    }

    public void setMu(Complex mu) {
        this.re.setText(String.valueOf(mu.re()));
        this.im.setText(String.valueOf(mu.im()));
    }

    private void initComponents() {
        this.title = new JLabel();
        this.muLabel = new JLabel();
        this.imLabel = new JLabel();
        this.re = new JTextField();
        this.im = new JTextField();
        this.jLabel1 = new JLabel();
        this.JuliaPanel = new JuliaSelectPanel(217, 150, this);
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.drawButton = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Custom Quadratic Julia Set");
        this.setModal(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setName("Julia Set Selector");
        this.setResizable(false);
        this.title.setFont(new Font("Tahoma", 0, 14));
        this.title.setText("f(z) = z^2 + Mu");
        this.muLabel.setText("Mu = ");
        this.imLabel.setText("+ i");
        this.re.setText("0.36237");
        this.im.setText("0.32");
        this.jLabel1.setText("Click the Mandelbrot to select a value for Mu:");
        this.JuliaPanel.setPreferredSize(new Dimension(217, 150));
        GroupLayout JuliaPanelLayout = new GroupLayout(this.JuliaPanel);
        this.JuliaPanel.setLayout(JuliaPanelLayout);
        JuliaPanelLayout.setHorizontalGroup(JuliaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 217, Short.MAX_VALUE));
        JuliaPanelLayout.setVerticalGroup(JuliaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 150, Short.MAX_VALUE));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JuliaSelectDialogue.this.cancelButtonActionPerformed(evt);
            }
        });
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JuliaSelectDialogue.this.resetAction(evt);
            }
        });
        this.drawButton.setText("Draw");
        this.drawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JuliaSelectDialogue.this.drawButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText("You can use the mouse to move and zoom");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addGap(32, 32, 32).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.drawButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.muLabel).addGap(31, 31, 31)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.imLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.re, -1, 187, Short.MAX_VALUE).addComponent(this.im))).addGroup(layout.createSequentialGroup().addGap(88, 88, 88).addComponent(this.title)).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.JuliaPanel, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2))))).addGap(0, 0, Short.MAX_VALUE))).addGap(9, 9, 9)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.title).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.re).addComponent(this.muLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.im, -2, -1, -2).addComponent(this.imLabel)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.JuliaPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.resetButton).addComponent(this.drawButton)).addContainerGap()));
        this.JuliaPanel.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void resetAction(ActionEvent evt) {
        ((JuliaSelectPanel)this.JuliaPanel).reset();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void drawButtonActionPerformed(ActionEvent evt) {
        try {
            this.fractal.loadCustomJuliaQuadratic(new Complex(Double.parseDouble(this.re.getText()), Double.parseDouble(this.im.getText())));
            this.setVisible(false);
        }
        catch (NumberFormatException er) {
            JOptionPane.showMessageDialog(this.rootPane, "Invalid inputs", "Error", 0);
        }
    }
}

