/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import fractal.Fractal;
import fractal.IFractalWindow;
import fractal.JuliaSelectDialogue;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;

public class JuliaSelectPanel
extends JPanel
implements IFractalWindow {
    private Fractal fractal;
    private int width;
    private int height;
    private JuliaSelectDialogue dialogue;
    private Point mouseDown;

    public JuliaSelectPanel(int _width, int _height, JuliaSelectDialogue _dialogue) {
        this.fractal = new Fractal(_width, _height, _dialogue.getThreads());
        this.width = _width;
        this.height = _height;
        this.fractal.setChunkWidth(8);
        this.fractal.setWindow(this);
        this.fractal.reset();
        this.fractal.getFunctionOfZ().setCycleMultiplier(0.0);
        this.dialogue = _dialogue;
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JuliaSelectPanel.this._mousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JuliaSelectPanel.this._mouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                JuliaSelectPanel.this._mouseClicked(evt);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                JuliaSelectPanel.this.mouseWheel(evt);
            }
        });
    }

    private void _mouseClicked(MouseEvent evt) {
        Point p = evt.getPoint();
        Complex mu = this.fractal.pixelToComplex(p.x, p.y);
        this.dialogue.setMu(mu);
    }

    private void _mousePressed(MouseEvent evt) {
        this.mouseDown = evt.getPoint();
    }

    private void _mouseReleased(MouseEvent evt) {
        Point mouseUp = evt.getPoint();
        this.fractal.drag(this.mouseDown, mouseUp);
        this.mouseDown = null;
    }

    private void mouseWheel(MouseWheelEvent evt) {
        int scroll = evt.getWheelRotation();
        this.fractal.scroll(scroll);
        double zoom = this.fractal.getZoom();
        int detail = (int)Math.round(100.0 / Math.pow(zoom, 0.35));
        this.fractal.setDetail(detail);
        evt.consume();
    }

    @Override
    public void paint(Graphics g) {
        this.fractal.draw(g);
        g.setColor(Color.LIGHT_GRAY);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    @Override
    public void saving(int progress) {
    }

    public void reset() {
        this.fractal.reset();
        this.fractal.setDetail(100);
        this.fractal.getFunctionOfZ().setCycleMultiplier(0.0);
    }
}

