/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import LukesBits.Complex;
import LukesBits.Vector;
import fractal.Fractal;
import fractal.FractalSettings;
import fractal.FunctionOfZ;
import java.awt.Color;

public class Mandelbrot
implements FunctionOfZ {
    protected double cycleMultiplier;
    protected double cycleOffset;
    protected boolean smoothColour;
    protected Fractal fractal;
    public double defaultCycleMultiplier = 30.0;
    public double defaultCycleOffset = 0.0;
    public Vector defaultCentre = new Vector(-0.5, 0.0);
    protected double k;

    public Mandelbrot(boolean _smoothColour) {
        this.k = 2.0;
        this.smoothColour = _smoothColour;
        this.cycleOffset = this.defaultCycleOffset;
        this.cycleMultiplier = this.defaultCycleMultiplier;
    }

    public Mandelbrot(double _k) {
        if (_k > 2.0) {
            this.defaultCycleMultiplier = 5.0;
            this.defaultCentre = new Vector(0.0, 0.0);
        }
        this.cycleMultiplier = this.defaultCycleMultiplier;
        this.cycleOffset = this.defaultCycleOffset;
        this.smoothColour = true;
        this.k = _k;
    }

    public Mandelbrot(double _cycleMultiplier, boolean _smoothColour) {
        this.k = 2.0;
        this.cycleMultiplier = _cycleMultiplier;
        this.cycleOffset = 0.0;
        this.smoothColour = _smoothColour;
    }

    @Override
    public void resetColour() {
        this.cycleMultiplier = this.defaultCycleMultiplier;
        this.cycleOffset = this.defaultCycleOffset;
    }

    public static boolean isPowerOf2(int value) {
        if (value < 2) {
            return false;
        }
        return Integer.bitCount(value) == 1;
    }

    protected Complex newZ(Complex z, Complex c) {
        if ((int)this.k == 2) {
            return z.times(z).plus(c);
        }
        Complex oldZ = z;
        if (this.k % 1.0 == 0.0) {
            if (Mandelbrot.isPowerOf2((int)this.k)) {
                int ik = (int)(Math.log(this.k) / Math.log(2.0));
                for (int i = 0; i < ik; ++i) {
                    z = z.times(z);
                }
            } else {
                int ik = (int)this.k;
                for (int i = 1; i < ik; ++i) {
                    z = z.times(oldZ);
                }
            }
        } else {
            z = z.power(this.k);
        }
        return z.plus(c);
    }

    public static boolean isPointIn(Complex c) {
        return Mandelbrot.isPointIn(c, 1000000);
    }

    public static boolean isPointIn(Complex c, int detail) {
        int i;
        Complex z = new Complex(0.0, 0.0);
        for (i = 0; z.magnitudeSqrd() < 4.0 && i < detail; ++i) {
            z = z.times(z).plus(c);
        }
        return i < detail;
    }

    @Override
    public Color getColourFor(Complex z, Complex c, int detail) {
        int i;
        double s = 0.0;
        for (i = 0; z.magnitudeSqrd() < 4.0 && i < detail; ++i) {
            z = this.newZ(z, c);
        }
        if (i == detail) {
            return new Color(0, 0, 0);
        }
        if (this.cycleMultiplier == 0.0) {
            return new Color(255, 255, 255);
        }
        if (!this.smoothColour) {
            s = i;
        } else {
            if (this.k == 2.0) {
                z = this.newZ(z, c);
                z = this.newZ(z, c);
                z = this.newZ(z, c);
                z = this.newZ(z, c);
                z = this.newZ(z, c);
            }
            s = (double)i + 1.0 - Math.log(Math.log(z.abs())) / Math.log(this.k);
        }
        double cycleSize = Math.log(detail) * this.cycleMultiplier;
        double colour = (s + this.cycleOffset * cycleSize) % cycleSize / cycleSize;
        return Color.getHSBColor((float)colour, 0.8f, 1.0f);
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean detailed) {
        return "f(z) = z^" + this.k + " + c" + (detailed ? ", CycleMultiplier: " + this.cycleMultiplier + ", CycleOffset: " + this.cycleOffset : "");
    }

    @Override
    public Vector defaultCentre() {
        return this.defaultCentre;
    }

    @Override
    public int defaultDetail() {
        return 50;
    }

    @Override
    public double defaultZoom() {
        return 3.0;
    }

    @Override
    public FractalSettings defaultSettings() {
        return new FractalSettings(this.defaultZoom(), this.defaultDetail(), this.defaultCentre(), this);
    }

    @Override
    public double getCycleMultiplier() {
        return this.cycleMultiplier;
    }

    @Override
    public double getCycleOffset() {
        return this.cycleOffset;
    }

    @Override
    public double getDefaultCycleOffset() {
        return this.defaultCycleOffset;
    }

    @Override
    public double getDefaultCycleMultiplier() {
        return this.defaultCycleMultiplier;
    }

    @Override
    public void setCycleMultiplier(double _cycleMultiplier) {
        this.cycleMultiplier = _cycleMultiplier;
    }

    @Override
    public void setCycleOffset(double _cycleOffset) {
        this.cycleOffset = _cycleOffset;
    }
}

