/*
 * Copyright Luke Wallin 2012
 */
package fractal;

import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ProgressMonitor;

/**
 *
 * @author Luke
 */
public class CustomExport extends javax.swing.JDialog {

    /**
     * Creates new form CustomExport
     */
    private Fractal fractal;
    private Window parent;
    
    public CustomExport(Fractal _fractal,Window _parent) {
        super(_parent);
        
        parent=_parent;
        
        fractal=_fractal;
        
        initComponents();
        
        pack();
        setResizable(false);
        setLocationRelativeTo(_parent);
        //setAlwaysOnTop(true);
        
        //show make it act like a normal dialogue: user can't click behind it and it can't dissapear behind the applet/jframe
         setModalityType(Dialog.DEFAULT_MODALITY_TYPE);
         //for helping with applets
         setModalExclusionType(java.awt.Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        widthLabel = new javax.swing.JLabel();
        heightLabel = new javax.swing.JLabel();
        width = new javax.swing.JTextField();
        height = new javax.swing.JTextField();
        aaLabel = new javax.swing.JLabel();
        aaSelect = new javax.swing.JComboBox();
        cancel = new javax.swing.JButton();
        export = new javax.swing.JButton();
        infoBox = new javax.swing.JCheckBox();
        infoLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Export Image");
        setModalExclusionType(java.awt.Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        setModalityType(java.awt.Dialog.ModalityType.APPLICATION_MODAL);

        widthLabel.setText("Width");

        heightLabel.setText("Height");

        width.setText("1920");

        height.setText("1080");
        height.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                heightActionPerformed(evt);
            }
        });

        aaLabel.setText("AA");

        aaSelect.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "None", "2x", "4x", "8x" }));
        aaSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aaSelectActionPerformed(evt);
            }
        });

        cancel.setText("Cancel");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelActionPerformed(evt);
            }
        });

        export.setText("Export");
        export.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exportActionPerformed(evt);
            }
        });

        infoBox.setSelected(true);
        infoBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                infoBoxActionPerformed(evt);
            }
        });

        infoLabel.setText("Info");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(widthLabel)
                            .addComponent(heightLabel)
                            .addComponent(aaLabel)
                            .addComponent(infoLabel))
                        .addGap(18, 18, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(height, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 115, Short.MAX_VALUE)
                                .addComponent(width)
                                .addComponent(aaSelect, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addComponent(infoBox)))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(cancel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE)
                        .addComponent(export)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(widthLabel)
                    .addComponent(width, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(heightLabel)
                    .addComponent(height, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(aaLabel)
                    .addComponent(aaSelect, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(infoBox, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(infoLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(export)
                    .addComponent(cancel))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void heightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_heightActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_heightActionPerformed

    private void aaSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aaSelectActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_aaSelectActionPerformed

    private void infoBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_infoBoxActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_infoBoxActionPerformed

    private void cancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelActionPerformed
        // TODO add your handling code here:
        setVisible(false);
    }//GEN-LAST:event_cancelActionPerformed

    private void exportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exportActionPerformed
        String filename = fractal.getFileName();
        
        int aa = (int)Math.pow(2,aaSelect.getSelectedIndex());
//        switch(aaSelect.getSelectedIndex()){
//            case 0:
//                aa=1;
//                break;
//            case 1:
//                aa=2;
//                break;
//            case 2:
//                aa=4;
//                break;
//            case 3:
//                aa=8;
//                break;
//        }
        
        
        int w=Integer.parseInt(width.getText());
        int h = Integer.parseInt(height.getText());
        
        filename+="_"+w+"x"+h+ (aa > 1 ? "_"+aa+"aa" :"");
        
        if(infoBox.isSelected()){
            try {
                fractal.saveInfo(filename);
            } catch (IOException ex) {
                Logger.getLogger(CustomExport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        
        //if aa is greater than 1, we're aaing, so we need an extra 1 for the progress to finish
        ProgressMonitor progressMonitor = new ProgressMonitor(parent, "Exporting to "+filename+".png", null, 0, w+(aa > 1 ? 2 : 1));
        progressMonitor.setMillisToDecideToPopup(0);
        fractal.saveCertainRez(filename,w,h,aa,progressMonitor);
        
        setVisible(false);
    }//GEN-LAST:event_exportActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel aaLabel;
    private javax.swing.JComboBox aaSelect;
    private javax.swing.JButton cancel;
    private javax.swing.JButton export;
    private javax.swing.JTextField height;
    private javax.swing.JLabel heightLabel;
    private javax.swing.JCheckBox infoBox;
    private javax.swing.JLabel infoLabel;
    private javax.swing.JTextField width;
    private javax.swing.JLabel widthLabel;
    // End of variables declaration//GEN-END:variables
}
