/*
 * Decompiled with CFR 0.152.
 */
package LukesBits;

import LukesBits.Matrix;
import java.io.Serializable;
import java.util.Random;

public class Vector
implements Serializable {
    public double x;
    public double y;
    public double z;

    public Vector(double _x, double _y) {
        this(_x, _y, 0.0);
    }

    public Vector(double _x, double _y, double _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public boolean equals(Vector v) {
        return v != null && v.x == this.x && v.y == this.y && v.z == this.z;
    }

    public double get(int i) {
        if (i == 0) {
            return this.x;
        }
        if (i == 1) {
            return this.y;
        }
        return this.z;
    }

    public double getX() {
        return this.x;
    }

    public int getRoundedX() {
        return (int)Math.round(this.x);
    }

    public double getY() {
        return this.y;
    }

    public int getRoundedY() {
        return (int)Math.round(this.y);
    }

    public double getZ() {
        return this.z;
    }

    public int getRoundedZ() {
        return (int)Math.round(this.z);
    }

    public double getMagnitude() {
        double d = this.x * this.x + this.y * this.y + this.z * this.z;
        return Math.sqrt(d);
    }

    public double getMagnitudeSqrd() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double get2DAngle() {
        return Math.atan2(this.y, this.x);
    }

    public Vector getUnit() {
        double mag = this.getMagnitude();
        if (mag == 0.0) {
            return new Vector(0.0, 0.0, 0.0);
        }
        double invSize = 1.0 / mag;
        double newX = this.x * invSize;
        double newY = this.y * invSize;
        double newZ = this.z * invSize;
        return new Vector(newX, newY, newZ);
    }

    public Vector add(Vector a) {
        return new Vector(this.x + a.x, this.y + a.y, this.z + a.z);
    }

    public Vector add(Vector a, double coef) {
        return new Vector(this.x + coef * a.x, this.y + coef * a.y, this.z + coef * a.z);
    }

    public Vector subtract(Vector a, double coef) {
        return this.add(a, -coef);
    }

    public Vector subtract(Vector a) {
        return new Vector(this.x - a.x, this.y - a.y, this.z - a.z);
    }

    public double dot(Vector a) {
        return a.x * this.x + a.y * this.y + a.z * this.z;
    }

    public Vector cross(Vector b) {
        return new Vector(this.y * b.z - this.z * b.y, this.z * b.x - this.x * b.z, this.x * b.y - this.y * b.x);
    }

    public Vector twoDNormal() {
        return this.cross(new Vector(0.0, 0.0, 1.0).getUnit());
    }

    public Vector multiply(Double s) {
        return new Vector(this.x * s, this.y * s, this.z * s);
    }

    public Vector randomNormal() {
        Random r = new Random();
        return this.randomNormal(r);
    }

    public Vector rotate(Vector torque) {
        return this.rotate(torque.getUnit(), torque.getMagnitude());
    }

    public Matrix crossProductMatrix() {
        double[][] newM = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newM[i][j] = 0.0;
            }
        }
        newM[0][1] = -this.z;
        newM[0][2] = this.y;
        newM[1][0] = this.z;
        newM[1][2] = -this.x;
        newM[2][0] = -this.y;
        newM[2][1] = this.x;
        return new Matrix(newM);
    }

    public Matrix tensorProduct() {
        double[][] newM = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                newM[i][j] = this.get(i) * this.get(j);
            }
        }
        return new Matrix(newM);
    }

    public static Matrix rotationMatrix(Vector axis, double angle) {
        Vector u = axis.getUnit();
        Matrix R = Matrix.identity(3, 3).times(Math.cos(angle));
        R.plusEquals(u.crossProductMatrix().times(Math.sin(angle)));
        R.plusEquals(u.tensorProduct().times(1.0 - Math.cos(angle)));
        return R;
    }

    public Vector rotate(Vector axis, double angle) {
        Matrix R = Vector.rotationMatrix(axis, angle);
        return this.rotate(R);
    }

    public Vector rotate(Matrix R) {
        Matrix v = new Matrix(3, 1);
        v.set(0, 0, this.x);
        v.set(1, 0, this.y);
        v.set(2, 0, this.z);
        Matrix ans = R.times(v);
        return new Vector(ans.get(0, 0), ans.get(1, 0), ans.get(2, 0));
    }

    public Vector randomNormal(Random r) {
        double Nz;
        double Ny;
        double Nx;
        do {
            Nz = 0.0;
            Ny = 0.0;
            Nx = 0.0;
            switch (r.nextInt(3)) {
                case 0: {
                    Nx = 1.0 - r.nextDouble() * 2.0;
                    break;
                }
                case 1: {
                    Ny = 1.0 - r.nextDouble() * 2.0;
                    break;
                }
                case 2: {
                    Nz = 1.0 - r.nextDouble() * 2.0;
                }
            }
        } while (!this.validNormalSelection(Nx, Ny, Nz));
        if (Nx != 0.0) {
            if (this.z != 0.0) {
                Ny = 1.0 - r.nextDouble() * 2.0;
                Nz = -(this.x * Nx + this.y * Ny) / this.z;
            } else if (this.y != 0.0) {
                Nz = 1.0 - r.nextDouble() * 2.0;
                Ny = -(this.x * Nx + this.z * Nz) / this.y;
            }
        } else if (Ny != 0.0) {
            if (this.z != 0.0) {
                Nx = 1.0 - r.nextDouble() * 2.0;
                Nz = -(this.x * Nx + this.y * Ny) / this.z;
            } else if (this.x != 0.0) {
                Nz = 1.0 - r.nextDouble() * 2.0;
                Nx = -(this.y * Ny + this.z * Nz) / this.x;
            }
        } else if (Nz != 0.0) {
            if (this.y != 0.0) {
                Nz = 1.0 - r.nextDouble() * 2.0;
                Ny = -(this.x * Nx + this.z * Nz) / this.y;
            } else if (this.x != 0.0) {
                Nz = 1.0 - r.nextDouble() * 2.0;
                Nx = -(this.y * Ny + this.z * Nz) / this.x;
            }
        }
        Vector n = new Vector(Nx, Ny, Nz);
        return n.getUnit();
    }

    public Vector predictableNormal() {
        if (this.x != 1.0 || this.y != 0.0 || this.z != 0.0) {
            Vector n = new Vector(1.0, 0.0, 0.0);
            return this.cross(n).getUnit();
        }
        Vector n = new Vector(0.0, 1.0, 0.0);
        return this.cross(n).getUnit();
    }

    private boolean validNormalSelection(double Nx, double Ny, double Nz) {
        if (Nx != 0.0 && this.y == 0.0 && this.z == 0.0) {
            return false;
        }
        if (this.x == 0.0 && Ny != 0.0 && this.z == 0.0) {
            return false;
        }
        return this.x != 0.0 || this.y != 0.0 || Nz == 0.0;
    }

    public Vector copy() {
        return new Vector(this.x, this.y, this.z);
    }

    public String toString() {
        return "(" + (double)Math.round(this.x * 100.0) / 100.0 + "," + (double)Math.round(this.y * 100.0) / 100.0 + "," + (double)Math.round(this.z * 100.0) / 100.0 + ")";
    }
}

