/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package javatree;

import LukesBits.Vector;

/**
 *
 * @author Luke
 * 
 * Ported directly from PHPRayTracer
 * 
 * TODO - add a convert 3D to 2D method:
 * 
 * store the screencorners as properties.
 * and add line-plane intersection stuff
 * 
 * camera:  screen: 
 *    X ->   |                               ^
 *           |                              /|\
 *           |                              /|\
 *                                   world: /|\
 *                                           |
 * 
 */
public class Camera {
    private Vector pos,dir;
    private double lensDistance,lensSize;
    private Vector xDir,yDir,screenTopLeft;
    private double width,height;
    
    private int xPixels,yPixels;

    public Camera(Vector _pos,Vector _dir,double _lensDistance,double _lensSize){
        pos=_pos;
        dir=_dir.getUnit();
        lensDistance=_lensDistance;
        lensSize=_lensSize;
        
    }
    
    public Vector getPos(){
        return pos;
    }
    
    public void setPosAndDir(Vector _pos, Vector _dir){
        pos=_pos;
        dir=_dir.getUnit();
    }

    //pre-compute some stuff for a certain resolution
    public void setupRez(int _xPixels, int _yPixels){
        xPixels=_xPixels;
        yPixels=_yPixels;
        setupScreenCorners((double)yPixels/(double)xPixels);
    }
    
    public Vector ThreeDTo2D(Vector threeD){
        
        //project line from position in world to camera
        //find out where this line intersects with the screen
        
        Vector s = threeD;
        //line from threeD to camera = t*l + l0
        Vector d = pos.subtract(s);
        //TODO check for if d is now zero
        //if(d.)
        
        if(dir.dot(d)==0){
            //the normal and the line are perpendicular - therefore the line is in parralelle with the plane

            //does a point on the line line on the plane?
            //if($this->angle->dot($s->minus($d))==0){
            //    return array($s,$this->angle);
                //plane normal . (
           // }else{
                //return null;new double[]{-1,-1};
            return new Vector(0,0,0);
            //}
        }else{
            //not parallel
            //line:  r=s + td
            //t = (point on plane - s ) . n / d.n

            double t=screenTopLeft.subtract(s).dot(dir)/d.dot(dir);

            //collision point
            Vector c=s.add(d.multiply(t));
            
            
            Vector screenCollision=c.subtract(screenTopLeft);
            
            //how far along top of screen
            double x = xDir.dot(screenCollision);
            double y = yDir.dot(screenCollision);
            
            x = (x/width)*xPixels;
            y = (y/height)*yPixels;
            
            return new Vector(x,y);
        
        //idea: find vector from top left corner of screen to collision point.  then get values for top of screen dot with this, and side of screen dot with this
        //this will give how far along each 'axis' of the screen the ocllision point is, and this can be scaled to x,y coords
        }
        
        //return new Vector(0,0);
    }
    
    private Vector[] setupScreenCorners(double ratio){
        //dir=direction camera is facing, distance is distance of screen
        //$ratio=$aspect;
        //of the screen:
        
        //this means that as the window gets wider, the camera sort of zooms in
        //width=lensSize;
        //height=lensSize*ratio;
        
        //as the window gets wider, you see more!  much better for wider screens
        height=lensSize;
        width = lensSize/ratio;
        
        //v2 is horizontal vector
        //v1 is the other vector

        Vector n=dir;

        //massive hack - should probably work through the maths and find the special cases.
        if(n.x==0){
            n.x=0.00000001;
        }

        if(n.y==0){
            n.y=0.00000001;
        }

        if(n.z==0){
            n.z=0.00000001;
        }

        double v1z=1;//want this to face upwards where up is +ve z

        double v1y=-(n.z*n.y)/(n.x*n.x + n.y*n.y);

        double v1x=v1y*n.x/n.y;

        double v2x=1;
        double v2y=-n.x/n.y;
        double v2z=0;//horizontal!

        
        
        Vector v1=new Vector(v1x,v1y,v1z);
        v1=v1.getUnit().multiply(height/2);
        Vector v2=new Vector(v2x,v2y,v2z);
        v2=v2.getUnit().multiply(width/2);

        //HACK
        if(pos.y >0 ){
            v2=v2.multiply(-1.0);
        }
        //centre of the screen1
        Vector centre=pos.add(n,lensDistance);

        Vector topLeft=centre.subtract(v2).add(v1);
        Vector topRight=centre.add(v2).add(v1);

        Vector bottomLeft=centre.subtract(v2).subtract(v1);
        Vector bottomRight=centre.add(v2).subtract(v1);
        
        //remember useful stuff
        screenTopLeft=topLeft;
        xDir=topRight.subtract(topLeft).getUnit();
        yDir=bottomLeft.subtract(topLeft).getUnit();
        
        return new Vector[]{topLeft,bottomLeft,bottomRight,topRight};
    }
}
