/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;

import jargs.gnu.*;
import javax.imageio.*;
import java.io.*;
import java.awt.image.*;
import java.awt.*;

/**
 *
 * @author Luke
 */
//TODO give the tree a placeCamera method, and then re-work everything to be controlled by threads from here
public class Controller {

    public static void printUsage(){
        System.out.println("JavaTree Copyright (C) 2012 Luke Wallin\n"
                + "This program comes with ABSOLUTELY NO WARRANTY;\n"
                + "This is free software, and you are welcome to redistribute it\n"
                + "under certain conditions.  See Licence.txt\n\n"
                + "Usage: "
                + "-g --grow\n"
                + "With this enabled, the tree will grow gradually\n\n"
                + "-h --height\n"
                + "How long to grow the tree for.  Units of this a bit iffy atm.\n\n"
                + "-s --spin\n"
                + "With this enabled, the camera will rotate around the tree\n\n"
                + "-r --seed [int]\n"
                + "Seed for the pseudorandom sequence\n\n"
                + "-d --density [double]\n"
                + "How dense the wood is\n\n"
                + "-e --elasticity [double]\n"
                + "How stiff the wood is\n\n"
                + "-i --images\n"
                + "With this enabled, a folder of PNG images will be produced\n\n"
                + "-b --branch [double]\n"
                + "The chance that an offshoot will occur after each segment\n\n"
                + "-t --tip [double]\n"
                + "Radius of tips\n\n"
                + "-l --length [double]\n"
                + "Average length of a branch segment\n\n"
                + "-c --growthChange\n"
                + "How much the growth rate increases with age.");
    }
    
    public static void main(String[] args) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        /*try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(TestControlWindow.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(TestControlWindow.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(TestControlWindow.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(TestControlWindow.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }*/
        
        //new TestControlWindow().setVisible(true);
        
        /* Create and display the form */
        //java.awt.EventQueue.invokeLater(new Runnable() {

        //  public void run() {

        CmdLineParser parser = new CmdLineParser();

        CmdLineParser.Option growArg = parser.addBooleanOption('g', "grow");
        CmdLineParser.Option spinArg = parser.addBooleanOption('s', "spin");
        CmdLineParser.Option growToArg = parser.addDoubleOption('h', "height");
        CmdLineParser.Option seedArg = parser.addLongOption('r', "seed");
        // CmdLineParser.Option avgErrorArg = parser.addBooleanOption("avg");
        CmdLineParser.Option densityArg = parser.addDoubleOption('d', "density");
        CmdLineParser.Option elasticityArg = parser.addDoubleOption('e', "elasticity");
        CmdLineParser.Option imagesArg = parser.addBooleanOption('i', "images");
        CmdLineParser.Option branchArg = parser.addDoubleOption('b', "branch");
        CmdLineParser.Option tipRadiusArg = parser.addDoubleOption('t', "tip");
        CmdLineParser.Option muBranchLengthArg = parser.addDoubleOption('l', "length");
        CmdLineParser.Option growthRateChangeArg = parser.addDoubleOption('c', "growthChange");
        
        CmdLineParser.Option helpArg = parser.addBooleanOption("help");
        

        try {
            parser.parse(args);
        } catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            printUsage();
            //System.exit(2);
            
        }

        //controller properties:
        boolean grow = (Boolean) parser.getOptionValue(growArg, false);
        double growTo = (Double) parser.getOptionValue(growToArg, 100.0);
        boolean spin = (Boolean) parser.getOptionValue(spinArg, true);
        boolean images = (Boolean) parser.getOptionValue(imagesArg, false);
        
        boolean help = (Boolean) parser.getOptionValue(helpArg, false);
        
        //tree properties:
        long seed = (Long) parser.getOptionValue(seedArg, (long) Math.round(Math.random() * Long.MAX_VALUE));
        double density = (Double) parser.getOptionValue(densityArg, 1.0);
        double elasticity = (Double) parser.getOptionValue(elasticityArg, 4.0);
        double branchChance = (Double) parser.getOptionValue(branchArg, 0.7);
        double tipRadius = (Double) parser.getOptionValue(tipRadiusArg, 0.2);
        double muBranchLength = (Double) parser.getOptionValue(muBranchLengthArg, 25.0);
        double growthRateChange = (Double) parser.getOptionValue(growthRateChangeArg, 0.01);
        
        
        if(help){
            printUsage();
        }
        
        
        TreeParameters params = new TreeParameters();
        params.seed = seed;
        
        params.density = density;
        params.elasticity = elasticity;
        params.tipRadius = tipRadius;
        
        params.branchChance=branchChance;
        
        params.muBranchLength=muBranchLength;
        params.sigmaBranchLength = muBranchLength*0.3;
        params.growthRateChange=growthRateChange;
        
        //params.growthRate=1.5;
        
        
        //Tree tree = new Tree(new Vector(0, 0, -9.8), new Vector(0, 0, 10), new Vector(0, 0, 0),seed,tipRadius);
        //Tree tree = new Tree(new Vector(0, 0, -1), new Vector(0, 0, 1), new Vector(0, 0, 0), seed, tipRadius,density,elasticity,branch);
        Tree tree = new Tree(params);
        TreeWindow window = new TreeWindow(tree);

        String imagesDir = (int) (System.currentTimeMillis() / 1000L)+"";

        if (grow) {

            GrowTree g = new GrowTree(tree, growTo);
            Thread t = new Thread(g);
            t.start();

        } else {
            for (double x = 0; x < growTo; x += 0.1) {
                tree.grow(0.1);
            }
            window.repaint();
        }

        window.setVisible(true);

        if (spin) {
            RotateTree r = new RotateTree(tree, window,images,imagesDir);
            Thread t2 = new Thread(r);
            t2.start();
        } else {
            window.repaint();
        }
        //new TreeWindow(tree).setVisible(true);
        //   }
        //});

        if (images) {
            /*try {
                BufferedImage b = new BufferedImage(1000,1000,BufferedImage.TYPE_INT_RGB); // change sizes of course
                Graphics2D g = b.createGraphics();
                tree.Draw(g, 1000, 1000);
                
                
                ImageIO.write(b, "png", new File("test.png"));
            } catch (Exception e) {
            }*/
            
            new File(imagesDir).mkdir();
            try{
            FileWriter fstream = new FileWriter(imagesDir+"/treeInfo.txt", false);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(tree.toString());

            out.close();
            }catch(Exception e){
                System.err.println(e.getMessage());
            }
            
            //tree.saveImage("test/test.png");
        }
    }
}

class RotateTree implements Runnable {

    public Tree tree;
    public TreeWindow window;
    private boolean images;
    private String imagesDir;
    private int image;

    public RotateTree(Tree _tree, TreeWindow _window, boolean _images, String _imagesDir) {
        tree = _tree;
        window = _window;
        //are we going to create a directory of images?
        images=_images;
        imagesDir=_imagesDir;
        image=0;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(34);
                tree.rotateCamera(0.02);
                window.repaint();
                
                if(images){
                    tree.saveImage(imagesDir+"/"+image+".png",1920,1080);
                    image++;
                }

            } catch (Exception e) {
            }
        }
    }
}

