/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;

import LukesBits.Vector;
/**
 *
 * @author Luke
 */
public interface IBranch {
    
    public void grow(double time);
    
    //position of start of branch
    public Vector getStump();
    
    //position fraction between stump and tip
    //public Vector getFraction(double fraction);
    
    //position of end of branch
    public Vector getTip();
    
    //how long is this branch?
    public double getLength();
    
    public double getRadius();
    
    //public void rotate(Vector axis,double angle);
    
    public double getParentRadius();
    
    //weight of this branch and all its children.
    public double getMass();
    
    //get an absolute angle, that is not relative to the parent
    //TODO is this still needed?
    public Vector getAbsoluteAngle();
    
    //used by raytracer
    public Vector getParentAbsoluteAngle();
    
    public boolean hasChildren();
    
    //returns whether or not this branch is the continuation of its parent branch
    public boolean isTrunk();
    
    public IBranch getParent();
    
    //does htis need to be part of the interface?
    //public void generateRandomChildren();
    
    //add this if/when we need it
    //public Vector getAngle();
}
