/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;

/**
 *
 * @author Luke
 */
public class SquareRootHack {
    public static float sqrt(float number){
        
        int i = Float.floatToRawIntBits(number);
        float x2 = number * 0.5F;
        float threehalfs = 1.5F;
        
        //http://en.wikipedia.org/wiki/Fast_inverse_square_root
        i  = 0x5f3759df - ( i >> 1 );               
        float y  = Float.intBitsToFloat(i);
        y  = y * ( threehalfs - ( x2 * y * y ) );   // 1st iteration
//      y  = y * ( threehalfs - ( x2 * y * y ) );   // 2nd iteration, this can be removed
        
        return y;
    }
}
