/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JApplet;

/**
 *
 * @author Luke
 */
public class TreeApplet extends JApplet implements Runnable{

    private Thread thread;
    private Tree tree;
    private Graphics bufferGraphics;
    private Image bufferImage;
    private Dimension dim;
    /**
     * Initialization method that will be called after the applet is loaded into
     * the browser.
     */
    public void init() {
        // TODO start asynchronous download of heavy resources
        
        final double growTo = getParameter("growTo")==null ? 70.0 : Double.parseDouble(getParameter("growTo"));
        
        TreeParameters params = new TreeParameters();
        params.colourful=false;
        
        if(getParameter("seed")!=null){
            params.seed=Integer.parseInt(getParameter("seed"));
        }
        
        tree = new Tree(params);
        
        GrowTree g = new GrowTree(tree, growTo);
            Thread t = new Thread(g);
            t.start();

//        for(double g=0;g<70;g+=0.02){
//            tree.grow(0.02);
//        }
        //window.setVisible(true);

        RotateTreeApplet r = new RotateTreeApplet(tree,this);
        Thread t2 = new Thread(r);
        t2.start();
        dim =  getSize();
        
        bufferImage = createImage(dim.width,dim.height);
        
        bufferGraphics = bufferImage.getGraphics();
    }
    // TODO overwrite start(), stop() and destroy() methods
    public void start(){
        
        //repaint();
//        thread = new Thread(this);
//        thread.start();
    }
    
    public void stop(){
        //todo some non deprecated way of stopping it
      //  thread.stop();
    }
    
    public void paint(Graphics g){
        //Graphics _g = getBufferStrategy().getDrawGraphics();
        
        //Graphics2D _g = (Graphics2D)g;
        
        //_g.drawString("TESTING", 50, 50);
        
        //Dimension d = getSize();
//        
        tree.Draw(bufferGraphics,dim.width,dim.height);
        //getBufferStrategy().show();
        //g.dispose();
        
        g.drawImage(bufferImage, 0,0, this);
   }
    
    public void update(Graphics g) 
     { 
          paint(g); 
     }
    
    public void run(){
        
    }
}

class RotateTreeApplet implements Runnable {

    public Tree tree;
    public TreeApplet window;
    private int image;

    public RotateTreeApplet(Tree _tree, TreeApplet _window) {
        tree = _tree;
        window = _window;
        //are we going to create a directory of images?
        image=0;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(34);
                tree.rotateCamera(0.02);
                window.repaint();

            } catch (Exception e) {
            }
        }
    }
}