/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;

import LukesBits.Vector;
/**
 *
 * @author Luke
 */
public class TreeParameters {
    
    public Vector gravity,light,wind;
    public long seed;
    public double density,tipRadius,elasticity;
    public double branchChance,muBranchLength,sigmaBranchLength,minBranchLength;
    public double growthRate,growthRateChange;
    public double muNumChildren,sigmaNumChildren;
    public boolean drawAxis,colourful;
    public Vector pos,angle;
    public double scale;
    
    public TreeParameters(){
        gravity = new Vector(0,0,-1);
        light = new Vector(0,0,1);
        wind = new Vector(0,0,0);
        
        seed = Math.round(Math.random()*10000);
        
        density = 1.0;
        elasticity=4.0;
        tipRadius = 0.2;
        
        branchChance = 0.7;
        muBranchLength = 25.0;
        sigmaBranchLength = 15.0;
        minBranchLength = 10.0;
        
        muNumChildren = 1.1;
        sigmaNumChildren=1.0;
        
        growthRate = 3.0;
        
        growthRateChange = 0.01;
        
        drawAxis=false;
        colourful=true;
        
        pos = new Vector(0,0,0);
        angle = new Vector(0,0,1);
        scale=1.0;
    }
    
}
