/*
 * JavaTree - 3D tree generation library and demo GUI
    Copyright (C) 2012 Luke Wallin

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
package javatree;


import LukesBits.*;
/**
 *
 * @author Luke
 *   this class exists purely as an anchor for the normal branches - to avoid having to write a whole bunch of special cases for if parent is null.
 * 
 * This jsut returns base whenever asked for where its tip or base is.
 * 
 */

public class Trunk implements IBranch {
    
    private Vector base,angle;
    private Tree tree;
    private IBranch child;
    private double tipRadius;
    
    public Trunk(Tree _tree,Vector _base,Vector _angle){//, double _tipRadius){
        tree = _tree;
        base=_base;
        angle=_angle;
        child=null;
        //tipRadius=_tipRadius;
    }
    
    public void grow(double time){
        if(child==null){
            //child = new Branch(tree,this,angle,0);
            child = new Branch(tree,this,Vector.rotationMatrix(angle, 0),true);
            tree.addBranch(child);
            //child.generateRandomChildren();
        }
    }
    
    public void hackSetAngle(Vector _angle){
        angle=_angle;
    }
    
//    public void generateRandomChildren(){
//        
//    }
    
    //position of start of branch
    public Vector getStump(){
        return base;
    }
    
    public Vector getFraction(double f){
        return base;
    }
    
    //position of end of branch
    public Vector getTip(){
        return base;
    }
    
    //how long is this branch?
    public double getLength(){
        return 0;
    }
    
    public double getRadius(){
        //TODO, something clever with all the children?
        if(child==null){
            return 0;
        }
        return child.getRadius();
    }
    
    //get an absolute angle, that is not relative to the parent
    public Vector getAbsoluteAngle(){
        return angle;
        //return new Vector(0,0,0);
    }
    
    public void rotate(Vector axis,double a){
        //the parent branch has been rotated, so rotate our angle so that it is still normal to the parent's absoluteAngle
        angle=angle.rotate(axis, a);
        
        //shouldn't need this anymore!
        //child.rotate(axis, a);
    }
    
    public double getMass(){
        if(child==null){
            return 0;
        }
        return child.getMass();
    }

    @Override
    public double getParentRadius() {
        return getRadius();
    }
    
    @Override
    public boolean hasChildren() {
        return child!=null;
    }

    @Override
    public Vector getParentAbsoluteAngle() {
       return angle;
    }

    //this is slightly meaningless here, since it has no parent
    //reutrning false because although this is *the* trunk, it is not continuing a parent
    @Override
    public boolean isTrunk() {
        return false;
    }

    @Override
    public IBranch getParent() {
        return null;
    }
}
